﻿using CursoDesignPatterns.models;
using System;
using System.Collections.Generic;
using System.Text;

namespace CursoDesignPatterns
{
    public class Reprovado : IEstadoDeUmOrcamento
    {
        public void AplicaDescontoExtra(Orcamento orcamento)
        {
            throw new Exception("Orcamentos reprovados não recebem descontos extra");
        }

        public void Aprova(Orcamento orcamento)
        {
            throw new Exception("Orçamento está em reprovado, não pode ser aprovado agora");

        }

        public void Finaliza(Orcamento orcamento)
        {
            orcamento.EstadoAtual = new Finalizado();
        }

        public void Reprova(Orcamento orcamento)
        {
            throw new Exception("Orçamento já está em estado de reprova");
        }
    }
}
